# Builds a PyInstaller version of kiwix-hotspot
# from inside a mcr.microsoft.com/windows/servercore:ltsc2019 container
# expects the code base to reside in c:\code (in the container)

Set-StrictMode -Version Latest
$ErrorActionPreference = "Stop"
$PSDefaultParameterValues['*:ErrorAction']='Stop'
function ThrowOnNativeFailure {
    if (-not $?)
    {
        throw 'Native Failure'
    }
}

echo "### Starting kiwix-hotspot build ###"

echo "[*] Installing 7zip"
curl.exe -L -O https://drive.offspot.it/creator/build-dependencies/7zcli1900.zip
ThrowOnNativeFailure
Expand-Archive -LiteralPath 7zcli1900.zip -DestinationPath C:\
Test-Path -Path 'C:\7za.exe' -PathType Leaf

echo "[*] Installing (extracting actually) MSYS2"
curl.exe -L -o msys2-base-x86_64.tar.xz $Env:MSYSURL
ThrowOnNativeFailure
c:\7za.exe x .\msys2-base-x86_64.tar.xz
ThrowOnNativeFailure
c:\7za.exe x .\msys2-base-x86_64.tar
ThrowOnNativeFailure

echo "[*] Updating and upgrading MSYS2 packages"
C:\msys64\usr\bin\bash.exe --login -c "pacman -Syy --noconfirm"
ThrowOnNativeFailure
C:\msys64\usr\bin\bash.exe --login -c "pacman -Syy --noconfirm"
ThrowOnNativeFailure
C:\msys64\usr\bin\bash.exe --login -c "pacman -Syu --noconfirm"
ThrowOnNativeFailure
C:\msys64\usr\bin\bash.exe --login -c "pacman -Sy --needed --noconfirm git"

echo "[*] Installing pygobjects via msys/mingw"
C:\msys64\usr\bin\bash.exe --login -c "pacman -S --noconfirm mingw-w64-x86_64-gtk3 mingw-w64-x86_64-python3 mingw-w64-x86_64-python3-gobject"
ThrowOnNativeFailure

echo "[*] Installing pip on our mingw python"
curl.exe -L -O https://bootstrap.pypa.io/get-pip.py
ThrowOnNativeFailure
C:\msys64\mingw64\bin\python.exe get-pip.py
ThrowOnNativeFailure

echo "[*] Installing additional non-pure-python dependencies"
C:\msys64\usr\bin\bash.exe --login -c "pacman -S --noconfirm mingw-w64-x86_64-python-pynacl mingw-w64-x86_64-python-yaml mingw-w64-x86_64-python-psutil mingw-w64-x86_64-python-jinja mingw-w64-x86_64-python-paramiko mingw-w64-x86_64-python-scandir mingw-w64-x86_64-python-cryptography mingw-w64-x86_64-python-bcrypt mingw-w64-x86_64-libsodium"
ThrowOnNativeFailure

echo "[*] Installing pure-python dependencies"
C:\msys64\mingw64\bin\python.exe -m pip install -r c:\code\requirements-windows.txt
ThrowOnNativeFailure

echo "[*] Install PyInstaller"
C:\msys64\mingw64\bin\python.exe -m pip install pyinstaller
ThrowOnNativeFailure

echo "[*] Verify that both pygobjects and pyinstaller are present and ready"
C:\msys64\mingw64\bin\python.exe -c "import gi ; print(gi.__file__)"
ThrowOnNativeFailure
C:\msys64\mingw64\bin\python.exe -c 'from win32ctypes.pywin32 import pywintypes'
ThrowOnNativeFailure
C:\msys64\mingw64\bin\python.exe -c 'from win32ctypes.pywin32 import win32api'
ThrowOnNativeFailure
C:\msys64\mingw64\bin\pyinstaller.exe --help
ThrowOnNativeFailure

echo "[*] Seems all good, starting actual build"
cd c:\code
C:\msys64\mingw64\bin\pyinstaller.exe --log-level=DEBUG kiwix-hotspot-win64.spec
ThrowOnNativeFailure
